/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.sysutils;

import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceLocator {
    protected static final Locale EMPTY_LOCALE = new Locale("", "", "");

    private static void msg(String s) {
        System.out.println(s);
    }

    public static void printUsage() {
        ResourceLocator.msg("Usage:  filenet.vw.sysutils.ResourceLocator -resource <resourceName -cp <cppath>");
        ResourceLocator.msg("Or just filenet.vw.sysutils.ResourceLocator -inputfile <file> where file contains the arguments");
        ResourceLocator.msg(" e.g. ");
        ResourceLocator.msg("     resource=ResourceName");
        ResourceLocator.msg("     cp=<classpath, separate by path separator>");
        System.exit(1);
    }

    private static ResourceBundle findViaClassLoader(String basename, ClassLoader loader) {
        try {
            ResourceBundle rb = ResourceBundle.getBundle(basename, EMPTY_LOCALE, loader);
            return rb;
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static void main(String[] args) {
        String resourceName;
        VWCommandLineArgs c = new VWCommandLineArgs(args);
        c.list(System.out);
        if (c.isPresent("h")) {
            ResourceLocator.printUsage();
        }
        if ((resourceName = c.getParameter("resource")) == null) {
            ResourceLocator.printUsage();
        }
        String cpList = c.getParameter("cp");
        String[] items = cpList.split(File.pathSeparator);
        URL[] cpURL = new URL[1];
        int nItems = items == null ? 0 : items.length;
        ResourceLocator.msg("Num items = " + nItems);
        for (int i = 0; i < nItems; ++i) {
            String item = items[i];
            if (item == null) continue;
            ResourceLocator.msg("Searching " + resourceName + " in " + item);
            try {
                cpURL[0] = new File(item).toURL();
                URLClassLoader cl = new URLClassLoader(cpURL);
                if (ResourceLocator.findViaClassLoader(resourceName, cl) == null) continue;
                ResourceLocator.msg("!!!!------- FOUND IT IN " + item);
                break;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        ResourceLocator.msg("THE END..");
    }
}

